#include<bits/stdc++.h>
#include <iostream>
using namespace std;

unsigned int arr[200009];

// array of vectors holding position and weight
vector<vector<int>> paths(200009);

vector<int> reds;
vector<int> blues;
vector<bool> what_color_node(200009); // true: red, false: blue
vector<int> pointers_to_color(200009);
vector<int> node_weights(200009);

struct sparse_table{
    public:
    unordered_map<int,int> location_weight;
    int size_;
    vector<int> table[32];

    void print(){
    for(int i=0;i<get_biggest_smaller_power(size_)+1;i++){
        for(int j=0;j<table[i].size();j++){

            cout << table[i][j] << " ";
        }
        cout << endl;
    }
    }

    void copy_(vector<int> arr){
    for(int i=0;i<arr.size();i++){
        table[0].push_back(node_weights[arr[i]]);
        location_weight[node_weights[arr[i]]] = arr[i];
    }
    }

    void initialize(vector<int> arr){
        copy_(arr);
        for(int skip = 1,index=1;skip < size_+1;skip*=2){
            int i=0;
            while(i+skip < size_){

                table[index].push_back(min(table[index-1][i], table[index-1][i+1]));
                i++;
            }
        index++;
        }
        }

    int get_min_with_exluded_indexes(vector<int> exludes){ //calculate exluded pointings before
        int min_ = INT_MAX;
        int last = 0;
        sort(exludes.begin(),exludes.end());
        for(int i=0;i<exludes.size();i++){
            min_ = min(min_,get_min_from_range(last,exludes[i]-1));
            last=exludes[i]+1;
        }
        min_ = min(min_,get_min_from_range(last,size_-1));
        return min_;
    }
    get_biggest_smaller_power(int N){
        int i=0;
        while(N > 1){
             N /= 2;
            i++;
        }
        return i;
    }
    get_min_from_range(int first,int last){
        if(first>last)return INT_MAX;
        int power = get_biggest_smaller_power(last-first);
        return min(table[power][first], table[power][last - ( 1 << power)]);
    }



};

void decide_colors(int node,bool color){
    what_color_node[node] = color;
    if(color)   reds.push_back(node);
    else        blues.push_back(node);
    pointers_to_color[node] = color ? reds.size() : blues.size();
    for(int i=0;i<paths[node].size();i++){
        if(pointers_to_color[paths[node][i]] == 0){
            decide_colors( paths[node][i], color ^ 1);
        }
    }
}


int main()
{   int N;
    cin >> N;
    for(int i=1;i<=N;i++){
        cin >> node_weights[i];
    }
    int node1,node2;
    for(int i=1;i<N;i++){
        cin >> node1 >> node2;
        paths[node1].push_back(node2);
        paths[node2].push_back(node1);
    }
    decide_colors(1,1); // first is red
    sparse_table blue,red;
    blue.size_ = blues.size();
    red.size_ = reds.size();
    blue.initialize(blues);
    red.initialize(reds);
    int minimum = INT_MAX;
    vector<int> pointers_to_the_exludes;

    int BLUE_USED = 0;
    int RED_USED = 0;
    int RED_COLOR = 0;
    int BLUE_COLOR = 0;
    for(int i=1;i<=N;i++){
        for(int j=0;j<paths[i].size();j++){
            pointers_to_the_exludes.push_back(paths[i][j]);
        }
        if(what_color_node[i]){
                if(minimum > node_weights[i] + blue.get_min_with_exluded_indexes(pointers_to_the_exludes)){

                    minimum = node_weights[i] + blue.get_min_with_exluded_indexes(pointers_to_the_exludes);
                    RED_USED = 2; BLUE_USED = 0;
                    RED_COLOR = minimum;
                    node1 = i;
                    node2 = blue.location_weight[minimum - node_weights[i]];
                }
                
            }
        else{
            if(minimum > node_weights[i] + red.get_min_with_exluded_indexes(pointers_to_the_exludes)){

                    minimum = node_weights[i] + red.get_min_with_exluded_indexes(pointers_to_the_exludes);
                    RED_USED = 2; BLUE_USED = 0;
                    node1 = i;
                    node2 = red.location_weight[minimum - node_weights[i]];
                }
                
        }
    }
    cout << minimum << endl;
    cout << RED_USED << endl;
    if(RED_USED == 2) cout << 2 << endl <<  node1 << " " << node2 << endl << 0  << endl;
    else{
    cout << 1 << endl;
    cout << node1 << endl;
    cout << 1 << endl;
    cout << node2 << endl;
    }


}